<?php
// Zarinpal callback endpoint (v2)
// Verifies payment and delivers READY stock item or starts PERSONAL form.
require_once __DIR__ . '/lib.php';
db_init();

$order_id = (int)($_GET['order_id'] ?? 0);
$status = $_GET['Status'] ?? $_GET['status'] ?? '';
$authority = $_GET['Authority'] ?? $_GET['authority'] ?? '';

if (!$order_id || !$authority){
    http_response_code(400);
    echo "Bad Request";
    exit;
}

$order = order_get($order_id);
if (!$order){
    http_response_code(404);
    echo "Order Not Found";
    exit;
}

if (strtolower($status) !== 'ok'){
    echo "Payment canceled.";
    exit;
}

$payload = [
    "merchant_id" => ZARINPAL_MERCHANT_ID,
    "amount" => (int)$order['amount'],
    "authority" => (string)$authority
];

$ch = curl_init(ZARINPAL_VERIFY_URL);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload, JSON_UNESCAPED_UNICODE),
    CURLOPT_HTTPHEADER => ['Content-Type: application/json','Accept: application/json'],
    CURLOPT_CONNECTTIMEOUT => 10,
    CURLOPT_TIMEOUT => 30,
]);
$res = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);

if ($err){
    echo "Verify error.";
    exit;
}

$json = json_decode($res, true);
$code = $json['data']['code'] ?? null;
$ref_id = $json['data']['ref_id'] ?? null;

if ((int)$code === 100 || (int)$code === 101){
    order_set_status($order_id,'paid');

    $p = product_get((int)$order['product_id']);
    $u = user_by_id((int)$order['user_id']);

    // mark tx done
    $pdo = db();
    $pdo->prepare("UPDATE wallet_tx SET status='done', ref=? WHERE source='zarinpal' AND ref=?")->execute([(string)$ref_id,(string)$authority]);

    if ($p && $u){
        if ($p['type']==='ready'){
            // reserve & deliver one stock item
            $item = product_stock_reserve_one((int)$p['id'], $order_id);
            if (!$item){
                order_set_status($order_id,'out_of_stock', ['note'=>'no_stock_on_verify','ref_id'=>$ref_id]);
                tg_api('sendMessage',[
                    'chat_id'=>(int)$u['chat_id'],
                    'text'=>"⛔️ پرداخت تایید شد اما موجودی این محصول تمام شده بود.\nلطفاً با پشتیبانی تماس بگیر.\nشماره سفارش: #{$order_id}\nRef: {$ref_id}"
                ]);
            } else {
                require_once __DIR__ . '/webhook.php'; // for deliver_stock_item()
                deliver_stock_item((int)$u['chat_id'], (int)$u['tg_id'], $order_id, $item);
            }
        } else {
            // personal: start form in bot
            $payloadP = json_decode($p['payload'] ?? '{}', true);
            $fields = $payloadP['form_fields'] ?? [];
            $meta = ['form_fields'=>$fields,'answers'=>[],'step'=>0];
            $pdo->prepare("UPDATE orders SET meta=? WHERE id=?")->execute([json_encode($meta,JSON_UNESCAPED_UNICODE),$order_id]);

            state_set((int)$u['tg_id'],'personal_form', ['order_id'=>$order_id]);

            tg_api('sendMessage',[
                'chat_id'=>(int)$u['chat_id'],
                'text'=>"✅ پرداخت تایید شد.\nحالا فرم Apple ID اختصاصی رو تکمیل کن 👇\nشماره سفارش: #{$order_id}"
            ]);
            // ask first question
            require_once __DIR__ . '/webhook.php';
            ask_personal_next((int)$u['chat_id'], (int)$u['tg_id'], $order_id);
        }
    }

    echo "Payment verified. RefID: ".$ref_id;
    exit;
}

echo "Payment failed.";
